/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.nonliving;

import net.adventurez.entity.VoidShadeEntity;
import net.adventurez.init.EntityInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class VoidBulletEntity
extends AbstractHurtingProjectile {
    private int removeTicker;

    public VoidBulletEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level world) {
        super(entityType, world);
    }

    @Environment(value=EnvType.CLIENT)
    public VoidBulletEntity(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.VOID_BULLET, world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20334_(velocityX, velocityY, velocityZ);
    }

    public VoidBulletEntity(Level world, LivingEntity owner, double velocityX, double velocityY, double velocityZ) {
        super(EntityInit.VOID_BULLET, owner, velocityX, velocityY, velocityZ, world);
        this.m_7678_(owner.m_20185_() + velocityX * 1.2, owner.m_20186_() + owner.m_20191_().m_82376_() * 0.6 + velocityY * 1.2, owner.m_20189_() + velocityZ * 1.2, -owner.m_146908_(), owner.m_146909_());
        this.f_19860_ = owner.m_146909_();
        this.m_146922_(-owner.m_146908_());
        this.f_36813_ *= 3.6;
        this.f_36815_ *= 3.6;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected ParticleOptions m_5967_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50016_.m_49966_());
    }

    protected float m_6884_() {
        return 0.7f;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.removeTicker;
        if (this.m_9236_().m_5776_()) {
            if (this.removeTicker > 75) {
                for (int i = 0; i < 20; ++i) {
                    double d = this.m_20182_().m_7096_() + (double)(0.3f * this.m_9236_().m_213780_().m_188501_());
                    double e = (float)this.m_20182_().m_7098_() + this.m_9236_().m_213780_().m_188501_() * 0.3f;
                    double f = this.m_20182_().m_7094_() + (double)(0.3f * this.m_9236_().m_213780_().m_188501_());
                    double g = (double)this.m_9236_().m_213780_().m_188501_() * 0.2;
                    double h = (double)this.m_9236_().m_213780_().m_188501_() * 0.2;
                    double l = (double)this.m_9236_().m_213780_().m_188501_() * 0.2;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, g, h, l);
                }
            }
        } else if (this.removeTicker >= 80) {
            this.m_146870_();
        }
    }

    public boolean m_6060_() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity hittedEntity = entityHitResult.m_82443_();
        if (!(this.m_9236_().m_5776_() || hittedEntity instanceof VoidBulletEntity || hittedEntity instanceof VoidShadeEntity)) {
            this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
            hittedEntity.m_6469_(this.createDamageSource((Entity)this), 7.0f);
            this.m_146870_();
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                double d = this.m_20182_().m_7096_() + (double)(0.3f * this.m_9236_().m_213780_().m_188501_());
                double e = (float)this.m_20182_().m_7098_() + this.m_9236_().m_213780_().m_188501_() * 0.3f;
                double f = this.m_20182_().m_7094_() + (double)(0.3f * this.m_9236_().m_213780_().m_188501_());
                double g = (double)this.m_9236_().m_213780_().m_188501_() * 0.1;
                double h = (double)this.m_9236_().m_213780_().m_188501_() * 0.1;
                double l = (double)this.m_9236_().m_213780_().m_188501_() * 0.1;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, 3, g, h, l, 0.1);
            }
            this.m_146870_();
        }
    }

    private DamageSource createDamageSource(Entity entity) {
        return entity.m_269291_().m_269298_(EntityInit.VOID_BULLET_KEY, entity);
    }
}

